<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(config_value('site_name', 'Edge')); ?> - <?php echo $__env->yieldContent('title', 'Admin Home'); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.slim.min.js" integrity="sha256-kmHvs0B+OpCW5GVHUNjv9rOmY0IvSIRcf7zGUDTDQM8=" crossorigin="anonymous"></script>
    <link rel="icon" href="<?php echo e(config_value('site_favicon', asset('images/logo.png'))); ?>" type="image/png">

    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/admin.scss', 'resources/js/admin.js']); ?>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="admin-panel">
    <div class="admin-container">
        <aside class="admin-sidebar">
            <div class="sidebar-header">
                <div class="sidebar-logo">
                    <img src="<?php echo e(config_value('site_logo', asset('images/logo.png'))); ?>" alt="Logo">
                </div>
                <h2>Admin Panel</h2>
                <button class="sidebar-toggle-btn" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
            
            <div class="sidebar-user">
                <div class="user-avatar">
                    <img src="<?php echo e(auth()->user()->avatar); ?>" alt="<?php echo e(auth()->user()->name); ?>">
                </div>
                <div class="user-info">
                    <h4><?php echo e(auth()->user()->name); ?></h4>
                    <span class="user-role">
                        <?php echo e(auth()->user()->roles->pluck('name')->implode(', ')); ?>

                    </span>
                </div>
            </div>
            
            <div class="sidebar-nav">
                
                <div class="nav-category">Main</div>
                <ul>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('access dashboard')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.dashboard')); ?>">
                            <i class="fas fa-tachometer-alt"></i>
                            <span>Dashboard</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view error logs')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.errors.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.errors.index')); ?>">
                            <i class="fas fa-exclamation-triangle"></i>
                            <span>Error Logs</span>
                            <?php if(\App\Models\ErrorLog::unresolved()->count() > 0): ?>
                                <span class="badge badge-danger"><?php echo e(\App\Models\ErrorLog::unresolved()->count()); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            
                
                <div class="nav-category">Management</div>
                <ul>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view users')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.users.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.users.index')); ?>">
                            <i class="fas fa-users"></i>
                            <span>Users</span>
                        </a>
                    </li>
                    <?php endif; ?>
            
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view roles')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.roles*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.roles')); ?>">
                            <i class="fas fa-user-tag"></i>
                            <span>Roles</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view permissions')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.permissions*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.permissions')); ?>">
                            <i class="fas fa-list-check"></i>
                            <span>Permissions</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage server')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.servers.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.servers.index')); ?>">
                            <i class="fas fa-server"></i>
                            <span>Servers</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage news')): ?>
                   <li class="<?php echo e(request()->routeIs('admin.news.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.news.index')); ?>">
                            <i class="fas fa-scroll"></i>
                            <span>News</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    
                    <?php if(isset($pluginMenuItems['management']) && !empty($pluginMenuItems['management']['items'])): ?>
                        <?php $__currentLoopData = $pluginMenuItems['management']['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="<?php echo e($menuItem['active_routes'] && request()->routeIs($menuItem['active_routes']) ? 'active' : ''); ?>">
                                <a href="<?php echo e($menuItem['url']); ?>" 
                                   target="<?php echo e($menuItem['target'] ?? '_self'); ?>"
                                   title="<?php echo e($menuItem['description'] ?? $menuItem['label']); ?>">
                                    <i class="<?php echo e($menuItem['icon']); ?>"></i>
                                    <span><?php echo e($menuItem['label']); ?></span>
                                    <?php if($menuItem['badge']): ?>
                                        <span class="menu-badge"><?php echo e($menuItem['badge']); ?></span>
                                    <?php endif; ?>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    
                    <?php if(auth()->user()->hasRole('super-admin')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.plugins.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.plugins.index')); ?>">
                            <i class="fas fa-puzzle-piece"></i>
                            <span>Plugins</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            
                
                <div class="nav-category">Forum</div>
                <ul>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view forum categories')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.forum.categories*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.forum.categories')); ?>">
                            <i class="fas fa-folder-tree"></i>
                            <span>Categories</span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view forum boards')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.forum.boards*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.forum.boards')); ?>">
                            <i class="fas fa-th-list"></i>
                            <span>Boards</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            
                
                <div class="nav-category">Billing</div>
                <ul>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view transactions')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.transactions.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.transactions.index')); ?>">
                            <i class="fas fa-credit-card"></i>
                            <span>Transactions</span>
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view packages')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.packages.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.packages.index')); ?>">
                            <i class="fas fa-box"></i>
                            <span>Packages</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage store')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.coupons.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.coupons.index')); ?>">
                            <i class="fas fa-tags"></i>
                            <span>Coupons</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>

                
                <div class="nav-category">Configuration</div>
                <ul>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view configurations')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.configurations.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.configurations.index')); ?>">
                            <i class="fas fa-cog"></i>
                            <span>Configurations</span>
                        </a>
                    </li>

                    <li class="<?php echo e(request()->routeIs('admin.loading-screen.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.loading-screen.index')); ?>">
                            <i class="fas fa-spinner"></i>
                            <span>Loading Screen</span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage map')): ?>
                    <li class="<?php echo e(request()->routeIs('admin.map.*') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('admin.map.editor')); ?>">
                            <i class="fas fa-map"></i>
                            <span>Interactive Map</span>
                        </a>
                    </li>
                    <?php endif; ?>
                </ul>

                
                <?php if(isset($pluginMenuItems) && !empty($pluginMenuItems)): ?>
                    <?php $__currentLoopData = $pluginMenuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey => $categoryData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php if(!in_array($categoryKey, ['main', 'management', 'forum', 'billing', 'configuration'])): ?>
                            <div class="nav-category"><?php echo e($categoryData['category']['label']); ?></div>
                            <ul>
                                <?php $__currentLoopData = $categoryData['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="<?php echo e($menuItem['active_routes'] && request()->routeIs($menuItem['active_routes']) ? 'active' : ''); ?>">
                                        <a href="<?php echo e($menuItem['url']); ?>" 
                                           target="<?php echo e($menuItem['target'] ?? '_self'); ?>"
                                           title="<?php echo e($menuItem['description'] ?? $menuItem['label']); ?>">
                                            <i class="<?php echo e($menuItem['icon']); ?>"></i>
                                            <span><?php echo e($menuItem['label']); ?></span>
                                            <?php if($menuItem['badge']): ?>
                                                <span class="menu-badge"><?php echo e($menuItem['badge']); ?></span>
                                            <?php endif; ?>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

                
                <?php if(isset($pluginMenuItems)): ?>
                    <?php $__currentLoopData = ['main', 'management', 'forum', 'billing', 'configuration']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($pluginMenuItems[$categoryKey]) && !empty($pluginMenuItems[$categoryKey]['items'])): ?>
                            
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>
            
            <div class="sidebar-footer">
                <a href="<?php echo e(route('home')); ?>" title="Back to Site">
                    <i class="fas fa-home"></i>
                </a>
                <a href="<?php echo e(route('logout')); ?>" 
                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();" 
                   title="Logout">
                    <i class="fas fa-sign-out-alt"></i>
                </a>
                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                    <?php echo csrf_field(); ?>
                </form>
            </div>
        </aside>
        
        <main class="admin-main">
            <header class="admin-header">
                <div class="header-left">
                    <button class="menu-toggle" id="menuToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1><?php echo $__env->yieldContent('title', 'Dashboard'); ?></h1>
                </div>
                <div class="header-right">
                    <div class="header-user">
                        <button class="user-dropdown-btn">
                            <img src="<?php echo e(auth()->user()->avatar); ?>" alt="<?php echo e(auth()->user()->name); ?>">
                            <span><?php echo e(auth()->user()->name); ?></span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="user-dropdown">
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('logout')); ?>" 
                                       onclick="event.preventDefault(); document.getElementById('logout-form-header').submit();">
                                        <i class="fas fa-sign-out-alt"></i>
                                        <span>Logout</span>
                                    </a>
                                    <form id="logout-form-header" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                        <?php echo csrf_field(); ?>
                                    </form>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </header>
            
            <div class="admin-content">
                <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
                <?php endif; ?>
                
                <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
                <?php endif; ?>
                
                <?php echo $__env->yieldContent('content'); ?>
            </div>
            
            <footer class="admin-footer">
                <p>Edge v1.1.1</p>
            </footer>
        </main>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/layouts/admin.blade.php ENDPATH**/ ?>